-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.qDoneStone = false
    self.qDoneIron = false
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.qDoneFarms = 0
			self.allQuests = 0
    end    
  end
  
  if self.qDoneStone then
    self.p0:WinQuest('D08_STONE')
    self.p0:AddResource(2,140)
    self.p0:AddResource(4,50)
		self.allQuests = self.allQuests + 1
    self.qDoneStone = false
  end
  
  if self.qDoneFarms == 3 then
    self.p0:WinQuest('D08_FARMS')
    self.p0:AddResource(0,140)
    self.p0:AddResource(6,40)
		self.allQuests = self.allQuests + 1
    self.qDoneFarms = 0
  end
  
  if self.qDoneIron then
    self.p0:WinQuest('D08_IRON')
    self.p0:AddResource(3,120)
    self.p0:AddResource(7,30)
		self.allQuests = self.allQuests + 1
    self.qDoneIron = false
  end
	
	if self.allQuests == 3 then
		self.p0:UnlockCharacter("D_Earl-Havard")
		self.allQuests = 0
	end	
end

function OnTrigger(self, source, target)
  if target == "questStone" then
    self.qDoneStone = true
  elseif target == "questFarms" then
    self.qDoneFarms = self.qDoneFarms + 1 
  elseif target == "questIron" then
    self.qDoneIron = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.qDoneFarms = ar:Read()
		self.allQuests = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.qDoneFarms)
		ar:Write(self.allQuests)
  end
end


function CreateTriggerTargets(self)
  self:AddTriggerTarget("questStone")
  self:AddTriggerTarget("questFarms")
  self:AddTriggerTarget("questIron")
end
